﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.IO;

namespace Notatnik.NET
{
    public partial class Form1 : Form
    {
        bool tekstZmodyfikowany = false;

        public Form1()
        {
            InitializeComponent();
        }

        private void zamknijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (tekstZmodyfikowany)
            {
                DialogResult dr = MessageBox.Show("Czy zapisać zmiany w edytowanym dokumencie?", this.Text, MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question, MessageBoxDefaultButton.Button3);
                switch (dr)
                {
                    //case DialogResult.Yes: MessageBox.Show("Wstawić wywołanie metody zapisującej zawartość notatnika do pliku"); break;
                    case DialogResult.Yes: zapiszJakoToolStripMenuItem_Click(null, null); break;
                    case DialogResult.No: break;
                    case DialogResult.Cancel: e.Cancel = true; break;
                    default: e.Cancel = true; break;
                }
            }

        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            tekstZmodyfikowany = true;
            toolStripStatusLabel1.Text += " (zmodyfikowany)";
        }

        #region Menu plik
        public static string[] CzytajPlikTekstowy(string nazwaPliku)
        {
            List<string> tekst = new List<string>();
            try
            {
                using (StreamReader sr = new StreamReader(nazwaPliku))
                {
                    string wiersz;
                    while ((wiersz = sr.ReadLine()) != null)
                        tekst.Add(wiersz);
                }
                return tekst.ToArray();
            }
            catch (Exception e)
            {
                //MessageBox.Show("Błąd odczytu pliku " + nazwaPliku + " (" + e.Message + ")");
                MessageBox.Show(
                    "Błąd odczytu pliku " + nazwaPliku + "\nOpis wyjątku: " + e.Message,
                    "Notatnik.NET - Błąd przy wczytywaniu pliku",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
                return null;
            }
        }

        private void otwórzToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                string nazwaPliku = openFileDialog1.FileName;
                textBox1.Lines = CzytajPlikTekstowy(nazwaPliku);
                int ostatniSlash = nazwaPliku.LastIndexOf('\\');
                toolStripStatusLabel1.Text = nazwaPliku.Substring(ostatniSlash + 1, nazwaPliku.Length - ostatniSlash - 1);

                tekstZmodyfikowany = false;
            }
        }

        public static void ZapiszDoPlikuTekstowego(string nazwaPliku, string[] tekst)
        {
            using (StreamWriter sw = new StreamWriter(nazwaPliku))
            {
                foreach (string wiersz in tekst)
                    sw.WriteLine(wiersz);
            }
        }

        private void zapiszJakoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string nazwaPliku = openFileDialog1.FileName;
            if (nazwaPliku.Length > 0) saveFileDialog1.FileName = nazwaPliku;
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                nazwaPliku = saveFileDialog1.FileName;
                ZapiszDoPlikuTekstowego(nazwaPliku, textBox1.Lines);
                int ostatniSlash = nazwaPliku.LastIndexOf('\\');
                toolStripStatusLabel1.Text = nazwaPliku.Substring(ostatniSlash + 1, nazwaPliku.Length - ostatniSlash - 1);

                tekstZmodyfikowany = false;
            }

        }
        #endregion

        #region Menu widok
        private void pasekstanuToolStripMenuItem_Click(object sender, EventArgs e)
        {
            pasekstanuToolStripMenuItem.Checked = !pasekstanuToolStripMenuItem.Checked;
            statusStrip1.Visible = pasekstanuToolStripMenuItem.Checked;
        }

        private void czcionkaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            fontDialog1.Font = textBox1.Font;
            if (fontDialog1.ShowDialog() == DialogResult.OK)
                textBox1.Font = fontDialog1.Font;
        }

        private void tłoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            colorDialog1.Color = textBox1.BackColor;
            if (colorDialog1.ShowDialog() == DialogResult.OK)
                textBox1.BackColor = colorDialog1.Color;
        }
        #endregion

        #region Menu edycja
        private void cofnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Undo();
        }

        private void wytnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Cut();
        }

        private void kopiujToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Copy();
        }

        private void wklejToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Paste();
        }

        private void usuńToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectedText = "";
        }

        private void zaznaczWszystkoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectAll();
        }
        #endregion

        #region Drukowanie
        private StringReader sr = null;

        private void printDocument1_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
        {
            Font czcionka = textBox1.Font;
            int wysokoscWiersza = (int)czcionka.GetHeight(e.Graphics);
            int iloscLinii = e.MarginBounds.Height / wysokoscWiersza;
            
            //if (sr == null) sr = new StringReader(textBox1.Text); //pierwsza strona
            //przy dzieleniu linii nie dbamy o spacje
            if (sr == null)
            {
                string tekst = "";
                foreach (string wiersz in textBox1.Lines)
                {
                    float szerokosc = e.Graphics.MeasureString(wiersz, czcionka).Width;
                    if (szerokosc < e.MarginBounds.Width)
                    {
                        tekst += wiersz + "\n";
                    }
                    else
                    {
                        float sredniaSzerokoscLitery = szerokosc / wiersz.Length;
                        int ileLiterWWierszu = (int)(e.MarginBounds.Width / sredniaSzerokoscLitery);
                        /*
                        int ileRazy = wiersz.Length / ileLiterWWierszu; //ile pełnych wierszy
                        for (int i = 0; i < ileRazy; i++)
                        {
                            tekst += wiersz.Substring(i * ileLiterWWierszu, ileLiterWWierszu) + "\n";
                        }
                        tekst += wiersz.Substring(ileRazy * ileLiterWWierszu) + "\n"; //kopiowanie reszty wiersza
                        */
                        string skracanyWiersz = wiersz;
                        do
                        {
                            int ostatniaSpacja = skracanyWiersz.Substring(0, ileLiterWWierszu).LastIndexOf(' ');
                            int iloscLiter = ostatniaSpacja != -1 ? Math.Min(ostatniaSpacja, ileLiterWWierszu) : ileLiterWWierszu;
                            tekst += skracanyWiersz.Substring(0, iloscLiter) + "\n";
                            skracanyWiersz = skracanyWiersz.Substring(iloscLiter).TrimStart(' '); //pozostala czesc
                        } while (skracanyWiersz.Length > ileLiterWWierszu);
                        tekst += skracanyWiersz + "\n"; //ostatnia część
                    } //if-else
                } //foreach
                sr = new StringReader(tekst);
            } //if (sr==null)

            e.HasMorePages = true;

            for (int i = 0; i < iloscLinii; i++)
            {
                string wiersz = sr.ReadLine();
                if (wiersz == null)
                {
                    e.HasMorePages = false;
                    sr = null;
                    break;
                }
                e.Graphics.DrawString(wiersz,
                             czcionka,
                             Brushes.Black,
                             e.MarginBounds.Left,                     //x
                             e.MarginBounds.Top + i * wysokoscWiersza);   //y
            }

        }

        private void drukujToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (printDialog1.ShowDialog() == DialogResult.OK)
            {
                printDocument1.DocumentName = "Notatnik.NET - " + toolStripStatusLabel1.Text;
                //printDocument1.Print();
                backgroundWorker1.RunWorkerAsync();
            }
        }

        private void ustawieniaStronyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            pageSetupDialog1.ShowDialog();
        }

        private void podglądWydrukuToolStripMenuItem_Click(object sender, EventArgs e)
        {
            printPreviewDialog1.ShowDialog();
        }
        #endregion

        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
            printDocument1.Print();
        }
    }
}
